namespace Hive.Unity.Editor
{
    internal class XmlCommon
    {
        HiveConfigXmlData data;

        internal string universalLink;
        internal string hiveAppId;
        internal HiveConfigXML.ZoneType zone;
        internal bool useLog;
        internal bool ageGateU13;
        internal HiveConfigXML.HiveOrientationType hiveOrientation;
        internal string channel;
        internal string market;

        internal XmlCommon(HiveConfigXmlData data)
        {
            this.data = data;
            universalLink = data.Xml.universalLink;
            hiveAppId = data.Xml.HIVEAppID;
            zone = data.Xml.zone;
            useLog = data.Xml.useLog;
            ageGateU13 = data.Xml.ageGateU13;
            hiveOrientation = data.Xml.hiveOrientation;
            
            if(data.Xml.channel == null || data.Xml.channel == "") {
                channel = "C2S";        // 저장된 파일에 아무 설정이 없을 경우 HiveConfig Editor에 C2S를 기본값으로 노출
            } else {
                channel = data.Xml.channel;
            }

            market = data.Xml.market;
        }

        internal void Apply()
        {
            data.Xml.universalLink = universalLink;
            data.Xml.HIVEAppID = hiveAppId;
            data.Xml.zone = zone;
            data.Xml.useLog = useLog;
            data.Xml.ageGateU13 = ageGateU13;
            data.Xml.hiveOrientation = hiveOrientation;
            data.Xml.channel = channel;
            data.Xml.market = market;
            
        }
    }
}